@extends('web.layouts.container')

@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('visitorMessages.head')}}</li>
                </ol>
                <h3>{{__('visitorMessages.head')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>


    <section class="contact-pg">
        <div class="container">
            <div class="sec-heading wow fadeInUp" data-wow-duration="2s">
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                <h3>{{__('main.communicate_with_us')}}</h3>
                <span class="sub-title"> {{__('main.leave_your_message')}}</span>
            </div>
            <div class="row">
                <div class="col-lg-8 order-1 order-lg-0">
                    <div class="form-wrapper ">
                        <form action="{{route('send_contact_us')}}" method="post" class="contact_us_form">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input name="name" type="text" class="form-control" autocomplete="off" autofocus required />
                                        <label class="floating-label">{{__('visitorMessages.name')}}</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input name="email" type="email" class="form-control" autocomplete="off" autofocus required />
                                        <label class="floating-label">{{__('visitorMessages.email')}}</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input name="phone" type="tel" class="form-control" autocomplete="off" autofocus required />
                                        <label class="floating-label"> {{__('visitorMessages.phone')}}</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input name="subject" type="text" class="form-control" autocomplete="off" autofocus required />
                                        <label class="floating-label"> {{__('visitorMessages.subject')}} </label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <textarea name="message" class="form-control" rows="10" autocomplete="off" autofocus required></textarea>
                                        <label class="floating-label"> {{__('visitorMessages.message_placeholder')}}  </label>
                                    </div>
                                </div>
                            </div>

                            <button class="submit-butn contact_us_button" type="submit"> {{__('main.send')}}  </button>

                        </form>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="contact-links-sec">
                        <div class="item">
                            <div class="icon">
                                <i class="fab fa-whatsapp"></i>
                            </div>
                            <div class="text">
                                <h6 class="headline">  {{__('main.communicate_with_us')}}</h6>
                                <p class="data">{{isset($settings['site_phone']) ? $settings['site_phone'] : ''}}</p>
                            </div>
                        </div>
                        <div class="item">
                            <div class="icon">
                                <i class="far fa-envelope"></i>
                            </div>
                            <div class="text">
                                <h6 class="headline">{{__('visitorMessages.email')}}</h6>
                                <p class="data">{{isset($settings['site_email']) ? $settings['site_email'] : 'suport@gmail.com'}}</p>
                            </div>
                        </div>
                        <div class="item last-item">
                            <div class="icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="text">
                                <h6 class="headline">{{__('visitorMessages.address')}}</h6>
                                <p class="data">{{isset($settings['site_address']) ? $settings['site_address'] : ''}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="map-box mt-5">
            <iframe width="100%" height="600" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=1%20Grafton%20Street,%20Dublin,%20Ireland+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
